<?php $__env->startSection('title', __('Events')); ?>
<?php $__env->startSection('main-content'); ?>
    <!-- Main Content -->
    <div class="main-content">
        <section class="section">
            <div class="section-body">
                <div class="row">
                    <div class="col-lg-12">
                        <?php if(session('success')): ?>
                            <div class="alert alert-success">
                                <?php echo e(session('success')); ?>

                            </div>
                        <?php endif; ?>
                        <?php if(session('error')): ?>
                            <div class="alert alert-dander">
                                <?php echo e(session('error')); ?>

                            </div>
                        <?php endif; ?>
                    </div>
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h4>Events</h4>
                            </div>
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table class="table table-striped" id="table-1">
                                        <thead>
                                            <tr>
                                                <th>Sl. No.</th>
                                                <th>Image</th>
                                                <th>Title</th>
                                                <th>From Date</th>
                                                <th>To Date</th>
                                                <th>Description</th>
                                                <th>Status</th>
                                                <th>Action</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $__currentLoopData = $events; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $event): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td><?php echo e($index + 1); ?></td>
                                                    <td>
                                                        <?php if(!empty($event->image)): ?>
                                                            <img src="<?php echo e(asset('uploads/events/'.$event->image)); ?>" alt="Event Image" class="img-thumbnail" width="100">
                                                        <?php else: ?>
                                                            <img src="<?php echo e(asset('no-img.jpg')); ?>" alt="Event Image" class="img-thumbnail" width="100">
                                                        <?php endif; ?>

                                                    </td>
                                                    <td><?php echo e($event->title); ?></td>
                                                    <td><?php echo e(date("F d, Y", strtotime($event->from_date))); ?></td>
                                                    <td><?php echo e(date("F d, Y", strtotime($event->to_date))); ?></td>
                                                    <td><?php echo Str::limit(strip_tags($event->description), 50); ?></td>
                                                    <td>
                                                        <?php if($event->status == '1'): ?>
                                                            <a href="javascript:void(0)"
                                                                class="badge badge-success text-white status-badge"
                                                                data-event-id="<?php echo e($event->id); ?>">Active</a>
                                                        <?php else: ?>
                                                            <a href="javascript:void(0)"
                                                                class="badge badge-danger text-white status-badge"
                                                                data-event-id="<?php echo e($event->id); ?>">Not Active</a>
                                                        <?php endif; ?>
                                                    </td>
                                                    <td><a href="<?php echo e(route('admin.event.edit', $event->id)); ?>"
                                                            class="btn btn-warning"><i class="fa fa-pen"></i></a>&nbsp;<a
                                                            href="<?php echo e(route('admin.event.delete', $event->id)); ?>"
                                                            class="btn btn-danger"><i class="fa fa-times"></i></a>
                                                        
                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('scripts'); ?>
<script>
    $(document).ready(function () {
        $('.status-badge').click(function () {
            var eventId = $(this).data('event-id');
            var badge = $(this);

            $.ajax({
                type: 'POST',
                url: '<?php echo e(route("admin.change.event.status", ":eventId")); ?>'.replace(':eventId', eventId),
                headers: {
                    'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                },
                success: function (response) {
                    if (response.status === '1') {
                        badge.removeClass('badge-danger').addClass('badge-success').text('Active');
                    } else {
                        badge.removeClass('badge-success').addClass('badge-danger').text('Not Active');
                    }
                },
                error: function (error) {
                    console.log('Error:', error);
                }
            });
        });
    });
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/paramsof/goshala.trsoftech.com/resources/views/admin/pages/event/index.blade.php ENDPATH**/ ?>