
<?php $__env->startSection('title', __('Count Cow')); ?>
<?php $__env->startSection('main-content'); ?>
    <!-- Main Content -->
    <div class="main-content">
        <section class="section">
            <div class="section-body">
                <div class="row">
                    <div class="col-lg-12">
                        <?php if(session('success')): ?>
                            <div class="alert alert-success">
                                <?php echo e(session('success')); ?>

                            </div>
                        <?php endif; ?>
                        <?php if(session('error')): ?>
                            <div class="alert alert-danger">
                                <?php echo e(session('error')); ?>

                            </div>
                        <?php endif; ?>
                    </div>
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h4>Upload</h4>
                            </div>
                            <div class="card-body">
                                <form action="<?php echo e(route('count_cows.upload_excel')); ?>" method="POST"
                                    enctype="multipart/form-data">
                                    <?php echo csrf_field(); ?>
                                    <div class="row">
                                        <div class="col-md-6 col-sm-12">
                                            <div class="form-group">
                                                <label for="cow_excel">Select Cow Excel*</label>
                                                <input type="file" name="excel_file" class="form-control" required>
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-sm-12">
                                            <div class="form-group mt-3">
                                                <button type="submit" class="btn btn-primary mt-3">Upload</button>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h4>Update</h4>
                            </div>
                            <div class="card-body">
                                <form action="<?php echo e(route('count_cows.update_excel')); ?>" method="POST"
                                    enctype="multipart/form-data">
                                    <?php echo csrf_field(); ?>
                                    <div class="row">
                                        <div class="col-md-6 col-sm-12">
                                            <div class="form-group">
                                                <label for="cow_excel_update">Select Cow Excel*</label>
                                                <input type="file" name="excel_file" class="form-control" required>
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-sm-12">
                                            <div class="form-group mt-3">
                                                <button type="submit" class="btn btn-primary mt-3">Update</button>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>

                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h4>Events</h4>
                            </div>
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table class="table table-striped" id="table-1">
                                        <thead>
                                            <tr>
                                                <th>क्रम संख्या</th>
                                                <th>टैग क्रमांक</th>
                                                <th>आवक की दिनांक</th>
                                                <th>टैग का रंग</th>
                                                <th>नस्ल</th>
                                                <th>आयु</th>
                                                <th>नर/मादा</th>
                                                <th>गौवंश का रंग</th>
                                                <th>पहचान का चिन्ह</th>
                                                <th>अंधा/विकलांग/बीमार</th>
                                                <th>निकास की दिनांक</th>
                                                <th>कारण</th>
                                                <th>Status</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $__currentLoopData = $count_cows; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $count_cow): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td><?php echo e($index + 1); ?></td>
                                                    <td><?php echo e($count_cow->tag_number); ?></td>
                                                    <td><?php echo e($count_cow->arrival_date); ?></td>
                                                    <td><?php echo e($count_cow->tag_color); ?></td>
                                                    <td><?php echo e($count_cow->breed); ?></td>
                                                    <td><?php echo e($count_cow->age); ?></td>
                                                    <td><?php echo e($count_cow->gender); ?></td>
                                                    <td><?php echo e($count_cow->cattle_color); ?></td>
                                                    <td><?php echo e($count_cow->identification_mark); ?></td>
                                                    <td><?php echo e($count_cow->blind_disabled_sick); ?></td>
                                                    <td><?php echo e($count_cow->departure_date); ?></td>
                                                    <td><?php echo e($count_cow->reason); ?></td>
                                                    <td>
                                                        <?php if($count_cow->status): ?>
                                                        <span class="badge badge-success">Active</span>
                                                        <?php else: ?>
                                                        <span class="badge badge-danger">Inactive</span>
                                                        <?php endif; ?>
                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/paramsof/goshala.trsoftech.com/resources/views/admin/pages/cow/index.blade.php ENDPATH**/ ?>