<?php $__env->startSection('title', __('Users')); ?>
<?php $__env->startSection('main-content'); ?>
    <!-- Main Content -->
    <div class="main-content">
        <section class="section">
            <div class="section-body">
                <div class="row">
                    <div class="col-lg-12">
                        <?php if(session('success')): ?>
                            <div class="alert alert-success">
                                <?php echo e(session('success')); ?>

                            </div>
                        <?php endif; ?>
                    </div>
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h4>Users</h4>
                            </div>
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table class="table table-striped table-hover" id="tableExport" style="width:100%;">
                                        <thead>
                                            <tr>
                                                <th>Sl. No.</th>
                                                <th>Full Name</th>
                                                <th>Father Name</th>
                                                <th>Mobile No.</th>
                                                <th>Status</th>
                                                <th>Action</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td><?php echo e($index+1); ?></td>
                                                    <td><?php echo e($user->name); ?></td>
                                                    <td><?php echo e($user->father_name); ?></td>
                                                    <td><?php echo e($user->mobile_no); ?></td>
                                                    <td>
                                                        <?php if($user->status == '1'): ?>
                                                            <div class="badge badge-success">Active</div>
                                                        <?php else: ?>
                                                            <div class="badge badge-danger">Not Active</div>
                                                        <?php endif; ?>
                                                    </td>
                                                    <td><a href="<?php echo e(route('admin.user.edit', $user->id)); ?>" class="btn btn-warning"><i
                                                                class="fa fa-pen"></i></a>&nbsp;<a href="<?php echo e(route('admin.user.delete', $user->id)); ?>"
                                                            class="btn btn-danger"><i class="fa fa-times"></i></a>
                                                            
                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\goshala\resources\views/admin/pages/user/index.blade.php ENDPATH**/ ?>