<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

Route::get('test', function () {
   echo "test api route";
});

Route::post('/login', [App\Http\Controllers\Api\LoginController::class, 'login'])->name('login');
Route::post('/register', [App\Http\Controllers\Api\LoginController::class, 'register'])->name('register');
Route::post('/forgot', [App\Http\Controllers\Api\LoginController::class, 'forgot'])->name('forgot');
Route::post('/change-password', [App\Http\Controllers\Api\LoginController::class, 'changePassword'])->name('change.password');

Route::post('/user', [App\Http\Controllers\Api\UserController::class, 'index'])->name('user');
Route::post('/profile/update', [App\Http\Controllers\Api\UserController::class, 'updateProfile'])->name('update-profile');
Route::get('/banners', [App\Http\Controllers\Api\BannerController::class, 'index'])->name('banner-list');
Route::get('/events', [App\Http\Controllers\Api\EventController::class, 'index'])->name('event-list');
Route::post('/add-donation', [App\Http\Controllers\Api\DonationController::class, 'addDonation'])->name('add-donation');
Route::post('/donations', [App\Http\Controllers\Api\DonationController::class, 'donationList'])->name('donation-list');
Route::get('/count_cows', [App\Http\Controllers\Api\CountCowController::class, 'index'])->name('count.cows');


// //user route
// Route::post('user-list', [App\Http\Controllers\api\UserController::class, 'userList'])->name('user.list');
