<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Admin Routes
|--------------------------------------------------------------------------
|
| Here is where you can register admin routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "admin" middleware group. Make something great!
|
*/

Route::get('/hello', function () {
    echo "hello";
});

Route::group(['prefix' => 'admin'], function () {
    Route::get('/',[App\Http\Controllers\Admin\Auth\AuthController::class,'login'])->name('adminlogin');
    Route::post('/login-post',[App\Http\Controllers\Admin\Auth\AuthController::class,'postLogin'])->name('login.post');
    Route::group(['middleware'=>'admin'],function(){
        Route::get('/dashboard', [App\Http\Controllers\Admin\HomeController::class, 'index'])->name('admin.dashboard');
        Route::get('/profile', [App\Http\Controllers\Admin\HomeController::class, 'profile'])->name('admin.profile');
        Route::post('/profile-update', [App\Http\Controllers\Admin\HomeController::class, 'profileUpdate'])->name('admin.profile.update');
        Route::get('/setting', [App\Http\Controllers\Admin\HomeController::class, 'setting'])->name('admin.setting');
        Route::post('/setting-update', [App\Http\Controllers\Admin\HomeController::class, 'settingUpdate'])->name('admin.setting.update');


        Route::get('/users', [App\Http\Controllers\Admin\UserController::class, 'index'])->name('admin.users');
        Route::get('/add-new-users', [App\Http\Controllers\Admin\UserController::class, 'addNewAdminUser'])->name('admin.add_new.users');
        Route::post('/user', [App\Http\Controllers\Admin\UserController::class,'store'])->name('admin.user.store');
        Route::get('/users/{id}/edit', [App\Http\Controllers\Admin\UserController::class, 'edit'])->name('admin.user.edit');
        Route::post('/users/{id}/update', [App\Http\Controllers\Admin\UserController::class, 'update'])->name('admin.user.update');
        Route::get('/user/delete/{id}', [App\Http\Controllers\Admin\UserController::class, 'delete'])->name('admin.user.delete');
        Route::post('/change-status/{userId}', [App\Http\Controllers\Admin\UserController::class, 'changeStatus'])->name('admin.change.status');


        Route::get('/message', [App\Http\Controllers\Admin\MessageController::class, 'index'])->name('admin.message');
        Route::post('/message-send', [App\Http\Controllers\Admin\MessageController::class,'send'])->name('admin.message.send');

        Route::get('push-notification', [App\Http\Controllers\Admin\NotificationController::class, 'index'])->name('admin.notification');;
        Route::post('sendNotification', [App\Http\Controllers\Admin\NotificationController::class, 'sendNotification'])->name('admin.send.notification');


        Route::get('/banners', [App\Http\Controllers\Admin\BannerController::class, 'index'])->name('admin.banners');
        Route::get('/add-new-banner', [App\Http\Controllers\Admin\BannerController::class, 'addNewAdminBanner'])->name('admin.add_new.banner');
        Route::post('/banner', [App\Http\Controllers\Admin\BannerController::class,'store'])->name('admin.banner.store');
        Route::get('/banner/{id}/edit', [App\Http\Controllers\Admin\BannerController::class, 'edit'])->name('admin.banner.edit');
        Route::post('/banner/{id}/update', [App\Http\Controllers\Admin\BannerController::class, 'update'])->name('admin.banner.update');
        Route::get('/banner/delete/{id}', [App\Http\Controllers\Admin\BannerController::class, 'delete'])->name('admin.banner.delete');
        Route::post('/change-banner-status/{bannerId}', [App\Http\Controllers\Admin\BannerController::class, 'changeStatus'])->name('admin.change.banner.status');
        
        
        Route::get('/events', [App\Http\Controllers\Admin\EventController::class, 'index'])->name('admin.events');
        Route::get('/add-new-event', [App\Http\Controllers\Admin\EventController::class, 'addNewAdminEvent'])->name('admin.add_new.event');
        Route::post('/event', [App\Http\Controllers\Admin\EventController::class,'store'])->name('admin.event.store');
        Route::get('/event/{id}/edit', [App\Http\Controllers\Admin\EventController::class, 'edit'])->name('admin.event.edit');
        Route::post('/event/{id}/update', [App\Http\Controllers\Admin\EventController::class, 'update'])->name('admin.event.update');
        Route::get('/event/delete/{id}', [App\Http\Controllers\Admin\EventController::class, 'delete'])->name('admin.event.delete');
        Route::post('/change-event-status/{eventId}', [App\Http\Controllers\Admin\EventController::class, 'changeStatus'])->name('admin.change.event.status');

        
        Route::get('/count-cow', [App\Http\Controllers\Admin\CountCowController::class, 'index'])->name('admin.count.cow');
        Route::post('count_cows/upload-excel', [App\Http\Controllers\Admin\CountCowController::class, 'uploadExcel'])->name('count_cows.upload_excel');
        Route::post('count_cows/update-excel', [App\Http\Controllers\Admin\CountCowController::class, 'updateExcel'])->name('count_cows.update_excel');

                
                
        //logout route
        Route::get('/logout',[App\Http\Controllers\Admin\Auth\AuthController::class,'logout'])->name('admin.logout');
    });
});
