@extends('admin.layouts.app')
@section('title', __('Users'))
@section('main-content')
    <!-- Main Content -->
    <div class="main-content">
        <section class="section">
            <div class="section-body">
                <div class="row">
                    <div class="col-lg-12">
                        @if (session('success'))
                            <div class="alert alert-success">
                                {{ session('success') }}
                            </div>
                        @endif
                    </div>
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h4>Users</h4>
                            </div>
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table class="table table-striped table-hover" id="tableExport" style="width:100%;">
                                        <thead>
                                            <tr>
                                                <th>Sl. No.</th>
                                                <th>Full Name</th>
                                                <th>Father Name</th>
                                                <th>Mobile No.</th>
                                                <th>Status</th>
                                                <th>Action</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach ($users as $index => $user)
                                                <tr>
                                                    <td>{{ $index + 1 }}</td>
                                                    <td>{{ $user->name }}</td>
                                                    <td>{{ $user->father_name }}</td>
                                                    <td>{{ $user->mobile_no }}</td>
                                                    <td>
                                                        @if ($user->status == '1')
                                                            <a href="javascript:void(0)"
                                                                class="badge badge-success text-white status-badge"
                                                                data-user-id="{{ $user->id }}">Active</a>
                                                        @else
                                                            <a href="javascript:void(0)"
                                                                class="badge badge-danger text-white status-badge"
                                                                data-user-id="{{ $user->id }}">Not Active</a>
                                                        @endif
                                                    </td>
                                                    <td><a href="{{ route('admin.user.edit', $user->id) }}"
                                                            class="btn btn-warning"><i class="fa fa-pen"></i></a>&nbsp;<a
                                                            href="{{ route('admin.user.delete', $user->id) }}"
                                                            class="btn btn-danger"><i class="fa fa-times"></i></a>
                                                        {{-- &nbsp;<a
                                                            href="#" class="btn btn-info"><i
                                                                class="fa fa-trash"></i></a> --}}
                                                    </td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection
@push('scripts')
<script>
    $(document).ready(function () {
        $('.status-badge').click(function () {
            var userId = $(this).data('user-id');
            var badge = $(this);

            $.ajax({
                type: 'POST',
                url: '{{ route("admin.change.status", ":userId") }}'.replace(':userId', userId),
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                success: function (response) {
                    if (response.status === '1') {
                        badge.removeClass('badge-danger').addClass('badge-success').text('Active');
                    } else {
                        badge.removeClass('badge-success').addClass('badge-danger').text('Not Active');
                    }
                },
                error: function (error) {
                    console.log('Error:', error);
                }
            });
        });
    });
</script>
@endpush
