@extends('admin.layouts.app')
@section('title', __('Add New User'))
@section('main-content')
    <!-- Main Content -->
    <div class="main-content">
        <section class="section">
            <div class="section-body">
                <div class="row">
                    <div class="col-12 col-md-6 col-lg-12">
                        <div class="card">
                            <div class="card-header">
                                <h4>Add New User</h4>
                            </div>
                            <div class="card-body">
                                <form action="{{ route('admin.user.store') }}" method="post" enctype="multipart/form-data">
                                    @csrf
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Full Name<span class="text-danger">*</span>:</label>
                                                <input type="text"
                                                    class="form-control @error('name') is-invalid @enderror" name="name"
                                                    value="{{ old('name') }}" placeholder="Enter your full name">
                                                @error('name')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Father Name
                                                <!--<span class="text-danger">*</span>-->
                                                :</label>
                                                <input type="text" class="form-control @error('father_name') is-invalid @enderror" name="father_name"
                                                    value="{{ old('father_name') }}" placeholder="Enter your father name">
                                                @error('father_name')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Mobile No.<span class="text-danger">*</span>:</label>
                                                <input type="text" class="form-control @error('mobile_no') is-invalid @enderror" name="mobile_no"
                                                    value="{{ old('mobile_no') }}" placeholder="Enter your mobile no.">
                                                @error('mobile_no')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>City
                                                <!--<span class="text-danger">*</span>-->
                                                :</label>
                                                <input type="text" class="form-control @error('city') is-invalid @enderror" name="city"
                                                    value="{{ old('city') }}" placeholder="Enter your city">
                                                @error('city')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>State
                                                <!--<span class="text-danger">*</span>-->
                                                :</label>
                                                <input type="text" class="form-control @error('state') is-invalid @enderror" name="state"
                                                    value="{{ old('state') }}" placeholder="Enter your state">
                                                @error('state')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Pincode
                                                <!--<span class="text-danger">*</span>-->
                                                :</label>
                                                <input type="text" class="form-control @error('pincode') is-invalid @enderror" name="pincode"
                                                    value="{{ old('pincode') }}" placeholder="Enter your pincode">
                                                @error('pincode')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                        <!--<div class="col-md-6">-->
                                        <!--    <div class="form-group">-->
                                        <!--        <label>Donation Amount<span class="text-danger">*</span>:</label>-->
                                        <!--        <input type="text" class="form-control @error('donation_amount') is-invalid @enderror" name="donation_amount"-->
                                        <!--            value="{{ old('donation_amount') }}" placeholder="Enter your donation amount">-->
                                        <!--        @error('donation_amount')-->
                                        <!--            <span class="text-danger">{{ $message }}</span>-->
                                        <!--        @enderror-->
                                        <!--    </div>-->
                                        <!--</div>-->
                                        <!--<div class="col-md-6">-->
                                        <!--    <div class="form-group">-->
                                        <!--        <label>Duration<span class="text-danger">*</span>:</label>-->
                                        <!--        <select class="form-control @error('duration') is-invalid @enderror" name="duration">-->
                                        <!--            <option value="" selected>--selet--</option>-->
                                        <!--            <option value="daily" @if(old('duration') == 'daily') selected @endif>Daily</option>-->
                                        <!--            <option value="monthly" @if(old('duration') == 'monthly') selected @endif>Monthly</option>-->
                                        <!--            <option value="quarterly" @if(old('duration') == 'quarterly') selected @endif>Quarterly</option>-->
                                        <!--            <option value="yearly" @if(old('duration') == 'yearly') selected @endif>Yearly</option>-->
                                        <!--        </select>-->
                                        <!--        @error('duration')-->
                                        <!--            <span class="text-danger">{{ $message }}</span>-->
                                        <!--        @enderror-->
                                        <!--    </div>-->
                                        <!--</div>-->
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Pan
                                                <!--<span class="text-danger">*</span>-->
                                                :</label>
                                                <input type="text" class="form-control @error('pan') is-invalid @enderror" name="pan"
                                                    value="{{ old('pan') }}" placeholder="Enter your pan">
                                                @error('pan')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                        <!--<div class="col-md-6">-->
                                        <!--    <div class="form-group">-->
                                        <!--        <label>Donation Type<span class="text-danger">*</span>:</label>-->
                                        <!--        <select class="form-control @error('donation_type') is-invalid @enderror" name="donation_type">-->
                                        <!--            <option value="" selected>--selet--</option>-->
                                        <!--            <option value="goshala" @if(old('donation_type') == 'goshala') selected @endif>Goshala</option>-->
                                        <!--            <option value="aashram" @if(old('donation_type') == 'aashram') selected @endif>Aashram</option>-->
                                        <!--        </select>-->
                                        <!--        @error('donation_type')-->
                                        <!--            <span class="text-danger">{{ $message }}</span>-->
                                        <!--        @enderror-->
                                        <!--    </div>-->
                                        <!--</div>-->
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Password<span class="text-danger">*</span>:</label>
                                                <input type="text" class="form-control @error('password') is-invalid @enderror" name="password"
                                                    placeholder="Enter your password">
                                                @error('password')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                        <!--<div class="col-md-6">-->
                                        <!--    <div class="form-group">-->
                                        <!--        <label>Status<span class="text-danger">*</span>:</label>-->
                                        <!--        <select class="form-control @error('status') is-invalid @enderror" name="status">-->
                                        <!--            <option value="" selected>--selet--</option>-->
                                        <!--            <option value="1" @if(old('status') == '1') selected @endif>Active</option>-->
                                        <!--            <option value="0" @if(old('status') == '0') selected @endif>Not Active</option>-->
                                        <!--        </select>-->
                                        <!--        @error('status')-->
                                        <!--            <span class="text-danger">{{ $message }}</span>-->
                                        <!--        @enderror-->
                                        <!--    </div>-->
                                        <!--</div>-->
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label>Address<span class="text-danger">*</span>:</label>
                                                <textarea class="form-control @error('address') is-invalid @enderror" name="address">{{ old('address') }}</textarea>
                                                @error('address')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <input type="submit" class="btn btn-primary">
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection
