@extends('admin.layouts.app')
@section('title', __('Push Notification'))
@push('styles')

@endpush
@section('main-content')
     <!-- Main Content -->
     <div class="main-content">
        <section class="section">
            <div class="section-body">
                <div class="row">
                    <div class="col-lg-12">
                        @if (session('success'))
                        <div class="alert alert-success" role="alert">
                            {{ session('success') }}
                        </div>
                        @endif
                    </div>
                    <div class="col-12 col-md-6 col-lg-12">
                        <div class="card">
                            <div class="card-header">
                                <h4>Push Notification</h4>
                            </div>
                            <div class="card-body">
                                <form action="{{ route('admin.send.notification') }}" method="post" enctype="multipart/form-data">
                                    @csrf
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label>User List<span class="text-danger">*</span>:</label>
                                                <select class="form-control @error('user') is-invalid @enderror" name="user">
                                                    <option value="" selected>--selet--</option>
                                                    @foreach ($users as $user)
                                                    <option value="{{ $user->mobile_no }}" @if(old('user') == $user->mobile_no) selected @endif>{{ $user->name }}</option>
                                                    @endforeach
                                                </select>
                                                @error('user')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label>Title<span class="text-danger">*</span>:</label>
                                                <input type="text" class="form-control @error('title') is-invalid @enderror" name="title" value="{{ old('title') }}">
                                                @error('title')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label>Message<span class="text-danger">*</span>:</label>
                                                <textarea class="form-control @error('message') is-invalid @enderror" name="message">{{ old('message') }}</textarea>
                                                @error('message')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                         <div class="col-md-6">
                                            <div class="form-group">
                                         
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <input type="submit" class="btn btn-primary" value="Send Notification">
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection
@push('scripts')

@endpush
