@extends('admin.layouts.app')
@section('title', __('Events'))
@section('main-content')
    <!-- Main Content -->
    <div class="main-content">
        <section class="section">
            <div class="section-body">
                <div class="row">
                    <div class="col-lg-12">
                        @if (session('success'))
                            <div class="alert alert-success">
                                {{ session('success') }}
                            </div>
                        @endif
                        @if (session('error'))
                            <div class="alert alert-dander">
                                {{ session('error') }}
                            </div>
                        @endif
                    </div>
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h4>Events</h4>
                            </div>
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table class="table table-striped" id="table-1">
                                        <thead>
                                            <tr>
                                                <th>Sl. No.</th>
                                                <th>Image</th>
                                                <th>Title</th>
                                                <th>From Date</th>
                                                <th>To Date</th>
                                                <th>Description</th>
                                                <th>Status</th>
                                                <th>Action</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach ($events as $index => $event)
                                                <tr>
                                                    <td>{{ $index + 1 }}</td>
                                                    <td>
                                                        @if(!empty($event->image))
                                                            <img src="{{ asset('uploads/events/'.$event->image) }}" alt="Event Image" class="img-thumbnail" width="100">
                                                        @else
                                                            <img src="{{ asset('no-img.jpg') }}" alt="Event Image" class="img-thumbnail" width="100">
                                                        @endif

                                                    </td>
                                                    <td>{{ $event->title }}</td>
                                                    <td>{{ date("F d, Y", strtotime($event->from_date)) }}</td>
                                                    <td>{{ date("F d, Y", strtotime($event->to_date)) }}</td>
                                                    <td>{!! Str::limit(strip_tags($event->description), 50) !!}</td>
                                                    <td>
                                                        @if ($event->status == '1')
                                                            <a href="javascript:void(0)"
                                                                class="badge badge-success text-white status-badge"
                                                                data-event-id="{{ $event->id }}">Active</a>
                                                        @else
                                                            <a href="javascript:void(0)"
                                                                class="badge badge-danger text-white status-badge"
                                                                data-event-id="{{ $event->id }}">Not Active</a>
                                                        @endif
                                                    </td>
                                                    <td><a href="{{ route('admin.event.edit', $event->id) }}"
                                                            class="btn btn-warning"><i class="fa fa-pen"></i></a>&nbsp;<a
                                                            href="{{ route('admin.event.delete', $event->id) }}"
                                                            class="btn btn-danger"><i class="fa fa-times"></i></a>
                                                        {{-- &nbsp;<a
                                                            href="#" class="btn btn-info"><i
                                                                class="fa fa-trash"></i></a> --}}
                                                    </td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection
@push('scripts')
<script>
    $(document).ready(function () {
        $('.status-badge').click(function () {
            var eventId = $(this).data('event-id');
            var badge = $(this);

            $.ajax({
                type: 'POST',
                url: '{{ route("admin.change.event.status", ":eventId") }}'.replace(':eventId', eventId),
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                success: function (response) {
                    if (response.status === '1') {
                        badge.removeClass('badge-danger').addClass('badge-success').text('Active');
                    } else {
                        badge.removeClass('badge-success').addClass('badge-danger').text('Not Active');
                    }
                },
                error: function (error) {
                    console.log('Error:', error);
                }
            });
        });
    });
</script>
@endpush
