@extends('admin.layouts.app')
@section('title', __('Add New Event'))
@section('main-content')
    <!-- Main Content -->
    <div class="main-content">
        <section class="section">
            <div class="section-body">
                <div class="row">
                    <div class="col-12 col-md-6 col-lg-12">
                        <div class="card">
                            <div class="card-header">
                                <h4>Add New Event</h4>
                            </div>
                            <div class="card-body">
                                <form action="{{ route('admin.event.store') }}" method="post" enctype="multipart/form-data">
                                    @csrf
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Title<span class="text-danger">*</span>:</label>
                                                <input type="text"
                                                    class="form-control @error('title') is-invalid @enderror" name="title" value="{{ old('title') }}">
                                                @error('title')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Image<span class="text-danger">*</span>:</label>
                                                <input type="file"
                                                    class="form-control @error('image') is-invalid @enderror" name="image"  value="{{ old('image') }}">
                                                @error('image')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>From Date<span class="text-danger">*</span>:</label>
                                                <input type="date"
                                                    class="form-control @error('from_date') is-invalid @enderror" name="from_date"  value="{{ old('from_date') }}">
                                                @error('from_date')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>To Date<span class="text-danger">*</span>:</label>
                                                <input type="date"
                                                    class="form-control @error('to_date') is-invalid @enderror" name="to_date"  value="{{ old('to_date') }}">
                                                @error('to_date')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>

                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label>Description<span class="text-danger">*</span>:</label>
                                                <textarea name="description" class="form-control @error('description') is-invalid @enderror" cols="30" rows="10">{{ old('description') }}</textarea>
                                                @error('description')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <input type="submit" class="btn btn-primary">
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection
