@extends('admin.layouts.app')
@section('title', __('Edit Event'))
@section('main-content')
    <!-- Main Content -->
    <div class="main-content">
        <section class="section">
            <div class="section-body">
                <div class="row">
                    <div class="col-12 col-md-6 col-lg-12">
                        <div class="card">
                            <div class="card-header">
                                <h4>Edit Event</h4>
                            </div>
                            <div class="card-body">
                                <form action="{{ route('admin.event.update', $event->id) }}" method="post" enctype="multipart/form-data">
                                    @csrf
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Title<span class="text-danger">*</span>:</label>
                                                <input type="text"
                                                    class="form-control @error('title') is-invalid @enderror" name="title" value="{{ old('title', $event->title) }}">
                                                @error('title')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Image<span class="text-danger">*</span>:</label>
                                                <input type="file"
                                                    class="form-control @error('image') is-invalid @enderror" name="image">
                                                <input type="hidden" name="oldevent" value="{{ $event->image }}">
                                                @error('image')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                                @if(!empty($event->image))
                                                    <img src="{{ asset('uploads/events/'.$event->image) }}" alt="Event Image" class="img-thumbnail" width="100">
                                                @else
                                                    <img src="{{ asset('no-img.jpg') }}" alt="Event Image" class="img-thumbnail" width="100">
                                                @endif
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>From Date<span class="text-danger">*</span>:</label>
                                                <input type="date"
                                                    class="form-control @error('from_date') is-invalid @enderror" name="from_date"  value="{{ old('title', $event->from_date) }}">
                                                @error('from_date')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>To Date<span class="text-danger">*</span>:</label>
                                                <input type="date"
                                                    class="form-control @error('to_date') is-invalid @enderror" name="to_date"  value="{{ old('title', $event->to_date) }}">
                                                @error('to_date')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>

                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label>Description<span class="text-danger">*</span>:</label>
                                                <textarea name="description" class="form-control @error('description') is-invalid @enderror" cols="30" rows="10">{{ old('description', $event->description) }}</textarea>
                                                @error('description')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <input type="submit" class="btn btn-primary" value="Update">
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection
