@extends('admin.layouts.app')
@section('title', __('Count Cow'))
@section('main-content')
    <!-- Main Content -->
    <div class="main-content">
        <section class="section">
            <div class="section-body">
                <div class="row">
                    <div class="col-lg-12">
                        @if (session('success'))
                            <div class="alert alert-success">
                                {{ session('success') }}
                            </div>
                        @endif
                        @if (session('error'))
                            <div class="alert alert-danger">
                                {{ session('error') }}
                            </div>
                        @endif
                    </div>
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h4>Upload</h4>
                            </div>
                            <div class="card-body">
                                <form action="{{ route('count_cows.upload_excel') }}" method="POST"
                                    enctype="multipart/form-data">
                                    @csrf
                                    <div class="row">
                                        <div class="col-md-6 col-sm-12">
                                            <div class="form-group">
                                                <label for="cow_excel">Select Cow Excel*</label>
                                                <input type="file" name="excel_file" class="form-control" required>
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-sm-12">
                                            <div class="form-group mt-3">
                                                <button type="submit" class="btn btn-primary mt-3">Upload</button>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h4>Update</h4>
                            </div>
                            <div class="card-body">
                                <form action="{{ route('count_cows.update_excel') }}" method="POST"
                                    enctype="multipart/form-data">
                                    @csrf
                                    <div class="row">
                                        <div class="col-md-6 col-sm-12">
                                            <div class="form-group">
                                                <label for="cow_excel_update">Select Cow Excel*</label>
                                                <input type="file" name="excel_file" class="form-control" required>
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-sm-12">
                                            <div class="form-group mt-3">
                                                <button type="submit" class="btn btn-primary mt-3">Update</button>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>

                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h4>Events</h4>
                            </div>
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table class="table table-striped" id="table-1">
                                        <thead>
                                            <tr>
                                                <th>क्रम संख्या</th>
                                                <th>टैग क्रमांक</th>
                                                <th>आवक की दिनांक</th>
                                                <th>टैग का रंग</th>
                                                <th>नस्ल</th>
                                                <th>आयु</th>
                                                <th>नर/मादा</th>
                                                <th>गौवंश का रंग</th>
                                                <th>पहचान का चिन्ह</th>
                                                <th>अंधा/विकलांग/बीमार</th>
                                                <th>निकास की दिनांक</th>
                                                <th>कारण</th>
                                                <th>Status</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach ($count_cows as $index => $count_cow)
                                                <tr>
                                                    <td>{{ $index + 1 }}</td>
                                                    <td>{{ $count_cow->tag_number }}</td>
                                                    <td>{{ $count_cow->arrival_date }}</td>
                                                    <td>{{ $count_cow->tag_color }}</td>
                                                    <td>{{ $count_cow->breed }}</td>
                                                    <td>{{ $count_cow->age }}</td>
                                                    <td>{{ $count_cow->gender }}</td>
                                                    <td>{{ $count_cow->cattle_color }}</td>
                                                    <td>{{ $count_cow->identification_mark }}</td>
                                                    <td>{{ $count_cow->blind_disabled_sick }}</td>
                                                    <td>{{ $count_cow->departure_date }}</td>
                                                    <td>{{ $count_cow->reason }}</td>
                                                    <td>
                                                        @if($count_cow->status)
                                                        <span class="badge badge-success">Active</span>
                                                        @else
                                                        <span class="badge badge-danger">Inactive</span>
                                                        @endif
                                                    </td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection
