@extends('admin.layouts.app')
@section('title', __('Banners'))
@section('main-content')
    <!-- Main Content -->
    <div class="main-content">
        <section class="section">
            <div class="section-body">
                <div class="row">
                    <div class="col-lg-12">
                        @if (session('success'))
                            <div class="alert alert-success">
                                {{ session('success') }}
                            </div>
                        @endif
                        @if (session('error'))
                            <div class="alert alert-dander">
                                {{ session('error') }}
                            </div>
                        @endif
                    </div>
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header">
                                <h4>Banners</h4>
                            </div>
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table class="table table-striped" id="table-1">
                                        <thead>
                                            <tr>
                                                <th>Sl. No.</th>
                                                <th>Banner Image</th>
                                                <th>Status</th>
                                                <th>Action</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach ($banners as $index => $banner)
                                                <tr>
                                                    <td>{{ $index + 1 }}</td>
                                                    <td>
                                                        @if(!empty($banner->image))
                                                            <img src="{{ asset('uploads/banners/'.$banner->image) }}" alt="Banner Image" class="img-thumbnail" width="100">
                                                        @else
                                                            <img src="{{ asset('no-img.jpg') }}" alt="Banner Image" class="img-thumbnail" width="100">
                                                        @endif

                                                    </td>
                                                    <td>
                                                        @if ($banner->status == '1')
                                                            <a href="javascript:void(0)"
                                                                class="badge badge-success text-white status-badge"
                                                                data-banner-id="{{ $banner->id }}">Active</a>
                                                        @else
                                                            <a href="javascript:void(0)"
                                                                class="badge badge-danger text-white status-badge"
                                                                data-banner-id="{{ $banner->id }}">Not Active</a>
                                                        @endif
                                                    </td>
                                                    <td><a href="{{ route('admin.banner.edit', $banner->id) }}"
                                                            class="btn btn-warning"><i class="fa fa-pen"></i></a>&nbsp;<a
                                                            href="{{ route('admin.banner.delete', $banner->id) }}"
                                                            class="btn btn-danger"><i class="fa fa-times"></i></a>
                                                        {{-- &nbsp;<a
                                                            href="#" class="btn btn-info"><i
                                                                class="fa fa-trash"></i></a> --}}
                                                    </td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection
@push('scripts')
<script>
    $(document).ready(function () {
        $('.status-badge').click(function () {
            var bannerId = $(this).data('banner-id');
            var badge = $(this);

            $.ajax({
                type: 'POST',
                url: '{{ route("admin.change.banner.status", ":bannerId") }}'.replace(':bannerId', bannerId),
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                success: function (response) {
                    if (response.status === '1') {
                        badge.removeClass('badge-danger').addClass('badge-success').text('Active');
                    } else {
                        badge.removeClass('badge-success').addClass('badge-danger').text('Not Active');
                    }
                },
                error: function (error) {
                    console.log('Error:', error);
                }
            });
        });
    });
</script>
@endpush
