@extends('admin.layouts.app')
@section('title', __('Edit Banner'))
@section('main-content')
    <!-- Main Content -->
    <div class="main-content">
        <section class="section">
            <div class="section-body">
                <div class="row">
                    <div class="col-12 col-md-6 col-lg-12">
                        <div class="card">
                            <div class="card-header">
                                <h4>Edit Banner</h4>
                            </div>
                            <div class="card-body">
                                <form action="{{ route('admin.banner.update', $banner->id) }}" method="post" enctype="multipart/form-data">
                                    @csrf
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Banner<span class="text-danger">*</span>:</label>
                                                <input type="file"
                                                    class="form-control @error('banner') is-invalid @enderror" name="banner">
                                                <input type="hidden" name="oldbanner" value="{{ $banner->image }}">
                                                @error('banner')
                                                    <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                                @if(!empty($banner->image))
                                                    <img src="{{ asset('uploads/banners/'.$banner->image) }}" alt="Banner Image" class="img-thumbnail" width="100">
                                                @else
                                                    <img src="{{ asset('no-img.jpg') }}" alt="Banner Image" class="img-thumbnail" width="100">
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <input type="submit" class="btn btn-primary" value="Update">
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection
