<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('count_cows', function (Blueprint $table) {
            $table->id();
            $table->date('arrival_date');
            $table->string('tag_number');
            $table->string('tag_color');
            $table->string('breed');
            $table->integer('age');
            $table->string('gender');
            $table->string('cattle_color');
            $table->string('identification_mark');
            $table->string('blind_disabled_sick');
            $table->date('departure_date');
            $table->string('reason');
            $table->enum('status',['1','0'])->default('1');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('count_cows');
    }
};
