<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('admins', function (Blueprint $table) {
            $table->id();
            $table->string('name')->default('Goshala');
            $table->string('username')->default('admin');
            $table->string('email')->unique();
            $table->string('password');
            $table->text('profilePic')->nullable();
            $table->string('phone')->default('0000000000');
            $table->text('address')->nullable();
            $table->enum('emailVerified', ['Y', 'N'])->default('Y');
            $table->string('mailVerificationCode')->nullable();
            $table->string('forgottenPasswordCode')->nullable();
            $table->enum('active', ['1', '0'])->default('1');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('admins');
    }
};
