<?php

namespace App\Imports;

use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use App\Models\CountCow;
use DateTime;

class CountCowImport implements ToModel, WithHeadingRow
{
    public function model(array $row)
    {
        $arrivalDate = $row['aavaka_ka_thanaka'];

        // Handle both date formats: d-m-Y and Excel date format
        $dateFormats = ['d-m-Y', 'd/m/Y', '42624'];
        $arrivalDateTime = null;

        foreach ($dateFormats as $format) {
            if ($format === '42624' && is_numeric($arrivalDate)) {
                // Convert Excel date format (e.g., 42624) to regular date
                $arrivalDateTime = DateTime::createFromFormat('d-m-Y', \PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject($arrivalDate)->format('d-m-Y'));
            } else {
                $arrivalDateTime = DateTime::createFromFormat($format, $arrivalDate);
            }

            if ($arrivalDateTime !== false) {
                break;
            }
        }

        $formattedArrivalDate = $arrivalDateTime ? $arrivalDateTime->format('d/m/Y') : null;

        $model = new CountCow([
            'arrival_date' => $formattedArrivalDate,
            'tag_number' => $row['taga_karamaka'],
            'tag_color' => $row['taga_ka_raga'],
            'breed' => $row['nasal'],
            'age' => $row['aaya'],
            'gender' => $row['naramatha'],
            'cattle_color' => $row['gavasha_ka_raga'],
            'identification_mark' => $row['pahacana_ka_canaha'],
            'blind_disabled_sick' => $row['athhavakalgabmara'],
            'departure_date' => $row['nakasa_ka_thanaka'],
            'reason' => $row['karanae'],
        ]);

        return $model;
    }
}
