<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UpdateUserRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'name' => 'required|string|max:255',
            // 'father_name' => 'required|string|max:255',
            'mobile_no' => 'required|string|numeric|digits:10',
            // 'city' => 'required|string|max:255',
            // 'state' => 'required|string|max:255',
            // 'pincode' => 'required|string|max:10',
            // 'pan' => 'required|string|max:255',
            // 'status' => 'required',
            'address' => 'required|string',
        ];
    }

    public function messages(): array
    {
        return [
            'name.required' => 'The full name field is required.',
            // 'father_name.required' => 'The father name field is required.',
            'mobile_no.required' => 'The mobile number is required.',
            'mobile_no.string' => 'The mobile number must be a string.',
            'mobile_no.numeric' => 'The mobile number must be numeric.',
            'mobile_no.digits' => 'The mobile number must be exactly 10 digits.',
            // 'city.required' => 'The city field is required.',
            // 'state.required' => 'The state field is required.',
            // 'pincode.required' => 'The pincode field is required.',
            // 'pan.required' => 'The PAN field is required.',
            // 'status.required' => 'The status field is required.',
            'address.required' => 'The address field is required.',
        ];
    }
}
