<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Validator;
use Hash;
use Illuminate\Support\Facades\Auth;



class UserController extends Controller
{
    public function index(Request $request)
    {
        $validate = Validator::make($request->all(), [
            'user_id' => 'required|numeric',
        ]);

        if ($validate->fails()) {
            return response()->json([
                'status' => false,
                'message' => 'Validation Error!',
                'data' => $validate->errors(),
            ], 400);
        }

        $user = User::find($request->input('user_id'));

        if (!$user) {
            return response()->json([
                'status' => false,
                'message' => 'User not found.',
            ], 404);
        }

        return response()->json([
            'status' => true,
            'message' => 'User retrieved successfully.',
            'data' => $user,
        ], 200);
    }

    public function updateProfile(Request $request)
    {
        //$user = auth()->user();
        $user = User::find($request->input('user_id'));
        if (!$user) {
            return response()->json([
                'status' => false,
                'message' => 'User not found.',
            ], 401);
        }

        $validator = Validator::make($request->all(), [
            'name' => 'required|string|max:255',
            'father_name' => 'required|string|max:255',
            'mobile_no' => 'required|string|numeric|digits:10|unique:users,mobile_no,' . $user->id,
            // 'city' => 'required|string|max:255',
            // 'pincode' => 'required|string|max:10',
            // 'state' => 'required|string|max:255',
        ]);

        if ($validator->fails()) {
            return response()->json([
                'status' => false,
                'message' => 'Validation Error!',
                'data' => $validator->errors(),
            ], 400);
        }

        $user->name = $request->input('name');
        $user->father_name = $request->input('father_name');
        $user->mobile_no = $request->input('mobile_no');
        $user->city = $request->input('city');
        $user->pincode = $request->input('pincode');
        $user->state = $request->input('state');
        $user->address = $request->input('address');
        $user->save();

        return response()->json([
            'status' => true,
            'message' => 'Profile updated successfully.',
            'data' => $user,
        ], 200);
    }


}
