<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Event;

class EventController extends Controller
{
    public function index()
    {
        $events = Event::where('status', 1)->orderBy('id', 'desc')->get();
        // Add the full URL to the image path
        $events = $events->map(function ($event) {
            $event->image_path = asset('uploads/events/' . $event->image);
            return $event;
        });

        return response()->json(['status'=>true,'message'=>'success', 'data' => $events]);
    }
}
