<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Donation;
use Illuminate\Support\Facades\Validator;


class DonationController extends Controller
{
    public function addDonation(Request $request)
    {
        // Validate the incoming request data
        $validator = Validator::make($request->all(), [
            'user_id' => 'required|exists:users,id',
            'amount' => 'required|numeric|min:0',
            'donation' => 'required|string|max:255',
            'duration_type' => 'required|string|max:255',
        ]);

        // If validation fails, return a JSON response with errors
        if ($validator->fails()) {
            return response()->json(['status'=>false,'errors' => $validator->errors()], 422);
        }

        $donation = Donation::create([
            'user_id' => $request->input('user_id'),
            'amount' => $request->input('amount'),
            'donation' => $request->input('donation'),
            'duration_type' => $request->input('duration_type'),
            'transaction_id' => $request->input('transaction_id'),
        ]);

        // Return a JSON response with the created donation data
        return response()->json(['status'=>true, 'message' => 'Donation created successfully','data' => $donation], 200);
    }
    
    public function donationList(Request $request)
    {
        // Validate the incoming request data
        $validator = Validator::make($request->all(), [
            'user_id' => 'required|exists:users,id'
        ]);

        // If validation fails, return a JSON response with errors
        if ($validator->fails()) {
            return response()->json(['status'=>false,'errors' => $validator->errors()], 400);
        }
        
        $donations = Donation::where('user_id', $request->input('user_id'))
            ->where('status', 1)
            ->orderBy('id', 'desc') // Adjust the column and order as needed
            ->get();

        if ($donations->isEmpty()) {
            return response()->json(['status'=>false,'errors' => 'No donations found for the specified user.'], 404);
        }
        
        return response()->json(['status'=>true,'message'=>'success', 'data' => $donations]);
    }
}
