<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Banner;

class BannerController extends Controller
{
    public function index()
    {
        $banners = Banner::orderBy('id', 'desc')->take(5)->get();
        // Add the full URL to the image path
        $banners = $banners->map(function ($banner) {
            $banner->image_path = asset('uploads/banners/' . $banner->image);
            return $banner;
        });

        return response()->json(['status'=>true,'message'=>'Success', 'data' => $banners]);
    }
}
