<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
//use Illuminate\Http\Request;
use App\Http\Requests\CreateUserRequest as Request;
use App\Http\Requests\UpdateUserRequest;
use App\Models\{User};
use Illuminate\Support\Facades\Hash;

class UserController extends Controller
{
    public function index()
    {
        $users = User::where('soft_delete', '0')->get();
        return view('admin.pages.user.index', compact('users'));
    }

    public function addNewAdminUser()
    {
        return view('admin.pages.user.form');
    }

    public function store(Request $request)
    {
        $validatedData = $request->validated();
        //User::create($validatedData);
        $user = new User;
        $user->name = $request->input('name');
        $user->father_name = $request->input('father_name');
        $user->mobile_no = $request->input('mobile_no');
        $user->city = $request->input('city');
        $user->state = $request->input('state');
        $user->pincode = $request->input('pincode');
        $user->pan = $request->input('pan');
        $user->password = Hash::make($request->input('password'));
        $user->address = $request->input('address');
        $user->save();
        // Optionally, you can redirect the user after successful storage.
        return redirect()->route('admin.users')->with('success', 'User created successfully');
    }

    public function edit($id)
    {
        $user = User::findOrFail($id);
        return view('admin.pages.user.edit', compact('user'));
    }

    public function update(UpdateUserRequest $request, $id)
    {
        $user = User::findOrFail($id);

        // Update the user with the new data
        //$user->update($request->all());

        // Update the user attributes

        $user->name = $request->input('name');
        $user->father_name = $request->input('father_name');
        $user->mobile_no = $request->input('mobile_no');
        $user->city = $request->input('city');
        $user->state = $request->input('state');
        $user->pincode = $request->input('pincode');
        $user->pan = $request->input('pan');
        // $user->status = $request->input('status');
        $user->address = $request->input('address');
        $user->save();

        // Redirect to the user index page with a success message
        return redirect()->route('admin.users')->with('success', 'User updated successfully.');
    }

    public function delete($id)
    {
        $user = User::find($id);
        $user->soft_delete = 1;
        $user->save();

        return redirect()->route('admin.users')->with('success', 'User deleted successfully.');
    }

    public function changeStatus($userId)
    {
        $user = User::find($userId);
        if (!$user) {
            return response()->json(['error' => 'User not found'], 404);
        }
        $user->status = $user->status == '1' ? '0' : '1';
        $user->save();
        return response()->json(['status' => $user->status]);
    }


}
