<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\{User, Notification};

class NotificationController extends Controller
{

    public function index()
    {
        $users = User::where('soft_delete','0')->get();
        return view("admin.pages.notification.index",compact("users"));
    }


    public function sendNotification(Request $request)
    {
        // Validate the request data
        $request->validate([
            'user' => 'required',
            'title' => 'required',
            'message' => 'required',
        ], [
            'user.required' => 'The user field is required.',
            'title.required' => 'The title field is required.',
            'message.required' => 'The message field is required.',
        ]);
    
        $user = User::where('mobile_no', $request->input('user'))->first();
        
        $firebaseToken = $user->firebase_token;
    
         $SERVER_API_KEY = env('FCM_SERVER_KEY');
    
       $url = 'https://fcm.googleapis.com/fcm/send';
    
    
    
            $data = [
                "to" => $firebaseToken,
                "data" => [
                    "title" => $request->title,
                    "body" => $request->message,  
                ]
            ];
            $encodedData = json_encode($data);
        
            $headers = [
                'Authorization:key=' . $SERVER_API_KEY,
                'Content-Type: application/json',
            ];
        
            $ch = curl_init();
            
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
            curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
            // Disabling SSL Certificate support temporarly
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $encodedData);
            // Execute post
            $result = curl_exec($ch);
            if ($result === FALSE) {
                die('Curl failed: ' . curl_error($ch));
            }        
            // Close connection
            curl_close($ch);
        // FCM response
        $notification = new Notification;
        $notification->title = $request->title;
        $notification->message = $request->message;
        $notification->save();
        //echo $result;
        return redirect()->back()->with('success', 'Notification send successfully');
    }
}
