<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\Admin;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Hash;



class HomeController extends Controller
{
    public function index() {
        return view('admin.home');
    }

    public function profile()
    {
        $id = Auth::guard('admin')->id();
        $admin = Admin::find($id);
        return view('admin.profile', compact('admin')); // Adjust the view path as needed
    }

    public function profileUpdate(Request $request)
    {
        // Validate the form data
        $validator = Validator::make($request->all(), [
            'name' => 'required|string|max:255',
            'email' => 'required|email|max:255',
            'phone' => 'required|string|digits:10',
            'address' => 'required|string',
        ]);

        // If validation fails, return with errors
        if ($validator->fails()) {
            return redirect()->back()
                ->withErrors($validator)
                ->withInput();
        }

        $admin = Admin::find($request->input('id'));
        // Update the image if a new one is provided
        if ($request->hasFile('image')) {
            $image = $request->file('image');
            $imageName = time() . '.' . $image->getClientOriginalExtension();
            $image->move(public_path('uploads'), $imageName);

            // Delete the old banner image if it exists
            if ($admin->profilePic) {
                File::delete(public_path('uploads/' . $admin->profilePic));
            }

        }else{
            $imageName = $request->input('oldimg');
        }

        // Update the banner information in the database
        $admin->name = $request->input('name');
        $admin->email = $request->input('email');
        $admin->profilePic = $imageName;
        $admin->phone = $request->input('phone');
        $admin->address = $request->input('address');
        $admin->save();

        return redirect()->back()->with('success', 'Profile updated successfully.');
    }

    public function setting()
    {
        $id = Auth::guard('admin')->id();
        $admin = Admin::find($id);
        return view('admin.setting', compact('admin')); // Adjust the view path as needed
    }


    public function settingUpdate(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'password' => [
                'required',
                'string',
                'min:8',
                'regex:/^(?=.*[a-z])(?=.*[A-Z])(?=.*\d)(?=.*[@$!%*?&])[A-Za-z\d@$!%*?&]+$/',
            ],
            'password_confirmation' => 'required:password|same:password',
        ], [
            'password.required' => 'The password field is required.',
            'password.string' => 'The password must be a string.',
            'password.min' => 'The password must be at least :min characters.',
            'password.regex' => 'The password must contain at least one lowercase letter, one uppercase letter, one digit, and one special character.',
            'password_confirmation.required' => 'The Confirm Password field is required.',
            'password_confirmation.same' => 'The password confirmation does not match the password.',
        ]);

        if ($validator->fails()) {
            return redirect()->back()
                ->withErrors($validator)
                ->withInput();
        }

        $admin = Admin::find($request->input('id'));
        $admin->password = Hash::make($request->input('password'));
        $admin->save();
        return redirect()->back()->with('success', 'Password updated successfully.');
    }




}
