<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Event;
use Illuminate\Support\Facades\Validator;
use File;


class EventController extends Controller
{

    public function index()
    {
        //$events = Event::all();
        $events = Event::orderBy('id', 'desc')->get();
        return view('admin.pages.event.index', compact('events'));
    }

    public function addNewAdminEvent()
    {
        return view('admin.pages.event.form');
    }

    public function store(Request $request)
    {
        $request->validate([
            'title' => 'required|string|max:255',
            'from_date' => 'required|date',
            'to_date' => 'required|date|after_or_equal:from_date',
            'description' => 'required|string',
            'image' => 'required|image|mimes:jpeg,png,jpg,gif|max:4048',
        ]);

        if ($request->hasFile('image')) {
            $image = $request->file('image');
            $imageName = time() . '.' . $image->getClientOriginalExtension();
            $image->move(public_path('uploads/events'), $imageName);
        }
        else
        {
            $imageName = '';
        }

        // Save the event information to the database
        $event = new Event();
        $event->title= $request->input('title');
        $event->from_date= $request->input('from_date');
        $event->to_date= $request->input('to_date');
        $event->image= $imageName;
        $event->description= $request->input('description');
        $event->save();
        return redirect()->route('admin.events')->with('success', 'Event created successfully');
    }

    public function edit($id)
    {
        $event = Event::findOrFail($id);
        return view('admin.pages.event.edit', compact('event'));
    }

    public function update(Request $request, $id)
    {
        // Find the event by ID
        $event = Event::find($id);
         // If the event is not found, return with an error message
        if (!$event) {
            return redirect()->back()->with('error', 'Event not found');
        }

        // Update the event image if a new one is provided
        if ($request->hasFile('image')) {
            $image = $request->file('image');
            $imageName = time() . '.' . $image->getClientOriginalExtension();
            $image->move(public_path('uploads/events'), $imageName);

            // Delete the old event image if it exists
            if ($event->image) {
                File::delete(public_path('uploads/events/' . $event->image));
            }

        }else{
            $imageName = $request->input('oldevent');
        }

        // Update the event information in the database
        $event->title= $request->input('title');
        $event->from_date= $request->input('from_date');
        $event->to_date= $request->input('to_date');
        $event->image= $imageName;
        $event->description= $request->input('description');
        $event->save();
        return redirect()->route('admin.events')->with('success', 'event updated successfully.');
    }

    public function delete($id)
    {
        // Find the event by ID
        $event = Event::find($id);

        // If the event is not found, return with an error message
        if (!$event) {
            return redirect()->back()->with('error', 'Event not found');
        }

        // Delete the event image if it exists
        if ($event->image) {
            File::delete(public_path('uploads/events/' . $event->image));
        }

        // Delete the event from the database
        $event->delete();
        return redirect()->route('admin.events')->with('success', 'Event deleted successfully.');
    }

    public function changeStatus($eventId)
    {
        $event = Event::find($eventId);
        if (!$event) {
            return response()->json(['error' => 'event not found'], 404);
        }
        $event->status = $event->status == '1' ? '0' : '1';
        $event->save();
        return response()->json(['status' => $event->status]);
    }
}
