<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Imports\CountCowImport;
use Maatwebsite\Excel\Facades\Excel;
use App\Models\CountCow;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\DB;


class CountCowController extends Controller
{
    function index()
    {
        $count_cows = CountCow::where('status',1)->get();
        return view('admin.pages.cow.index',compact('count_cows'));
    }

    public function uploadExcel(Request $request)
    {
        $request->validate([
            'excel_file' => 'required|mimes:xlsx,xls',
        ]);

        try {
            $file = $request->file('excel_file');
            $import = new CountCowImport();
            // Get the Excel file as an array
            $rows = Excel::toArray($import, $file);
            // Validate each row before inserting
            foreach ($rows[0] as $row) {
                // $validator = Validator::make($row, [
                //     'aavaka_ka_thanaka' => 'required',
                //     'taga_karamaka' => 'required',
                //     'taga_ka_raga' => 'required',
                //     'nasal' => 'required',
                //     'aaya' => 'required',
                //     'naramatha' => 'required',
                //     'gavasha_ka_raga' => 'required',
                //     'pahacana_ka_canaha' => 'required',
                // ]);

                // // If validation fails, skip inserting this row
                // if ($validator->fails()) {
                //     continue;
                // }

                $row['aavaka_ka_thanaka'] = $this->convertDateFormat($row['aavaka_ka_thanaka']);
                $newDate = date('Y-m-d', strtotime(str_replace('/', '-', $row['aavaka_ka_thanaka'])));
                // $ageParts = explode(' ', $row['aaya']);
                // $numericAge = floatval($ageParts[0]);
                // Insert the row into the database
                CountCow::create([
                    'arrival_date' => $newDate,
                    'tag_number' => $row['taga_karamaka'],
                    'tag_color' => $row['taga_ka_raga'],
                    'breed' => $row['nasal'],
                    'age' => $row['aaya'],
                    'gender' => $row['naramatha'],
                    'cattle_color' => $row['gavasha_ka_raga'],
                    'identification_mark' => $row['pahacana_ka_canaha'],
                    'blind_disabled_sick' => $row['athhavakalgabmara'],
                    'departure_date' => $row['nakasa_ka_thanaka'],
                    'reason' => $row['karanae'],
                ]);

            }

            return redirect()->back()->with('success', 'Uploaded successfully.');
        } catch (\Exception $e) {
            //echo "<pre>";
            //  print_r($e->getMessage());
            // Handle exceptions, log errors, or display a message
            return redirect()->back()->with('error', 'Error uploading data. Please check your file.');
        }
    }

    public function updateExcel(Request $request)
    {
        $request->validate([
            'excel_file' => 'required|mimes:xlsx,xls',
        ]);

        try {
            $file = $request->file('excel_file');
            $import = new CountCowImport();
            $rows = Excel::toArray($import, $file);


            DB::transaction(function () use ($rows) {
                foreach ($rows[0] as $row) {
                    $row['aavaka_ka_thanaka'] = $this->convertDateFormat($row['aavaka_ka_thanaka']);
                    $newDate = date('Y-m-d', strtotime(str_replace('/', '-', $row['aavaka_ka_thanaka'])));

                    $tagNumber = $row['taga_karamaka'];

                    // Extract the numeric part from the 'aaya' field
                    $ageParts = explode(' ', $row['aaya']);
                    $numericAge = floatval($ageParts[0]);

                    // Use updateOrInsert to either update or insert the record based on 'tag_number'
                    CountCow::updateOrInsert(
                        ['tag_number' => $tagNumber],
                        [
                            'arrival_date' => $newDate,
                            'tag_color' => $row['taga_ka_raga'],
                            'breed' => $row['nasal'],
                            'age' => $numericAge,
                            'gender' => $row['naramatha'],
                            'cattle_color' => $row['gavasha_ka_raga'],
                            'identification_mark' => $row['pahacana_ka_canaha'],
                            'blind_disabled_sick' => $row['athhavakalgabmara'],
                            'departure_date' => $row['nakasa_ka_thanaka'],
                            'reason' => $row['karanae'],
                        ]
                    );
                }
            });

            return redirect()->back()->with('success', 'Update successfully.');
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Error uploading data. Please check your file.');
        }
    }

    private function convertDateFormat($date)
    {
        $dateFormats = ['d-m-Y', 'd/m/Y', '42624']; // Add more formats if needed

        foreach ($dateFormats as $format) {
            if ($format === '42624' && is_numeric($date)) {
                $date = \PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject($date)->format('d-m-Y');
                break;
            } else {
                $dateTime = \DateTime::createFromFormat($format, $date);
                if ($dateTime !== false) {
                    $date = $dateTime->format('d-m-Y');
                    break;
                }
            }
        }

        return $date;
    }


}
