<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Banner;
use Illuminate\Support\Facades\Validator;
use File;


class BannerController extends Controller
{
    public function index()
    {
        //$banners = Banner::all();
        $banners = Banner::orderBy('id', 'desc')->get();
        return view('admin.pages.banner.index', compact('banners'));
    }

    public function addNewAdminBanner()
    {
        return view('admin.pages.banner.form');
    }

    public function store(Request $request)
    {
        $request->validate([
            'banner' => 'required|image|mimes:jpeg,png,jpg,gif|max:4048', // Add your specific rules for the banner file
        ]);

        if ($request->hasFile('banner')) {
            $image = $request->file('banner');
            $imageName = time() . '.' . $image->getClientOriginalExtension();
            $image->move(public_path('uploads/banners'), $imageName);

            // Save the banner information to the database
            $banner = new Banner();
            $banner->image= $imageName;
            $banner->save();
            return redirect()->route('admin.banners')->with('success', 'Banner created successfully');
        }
    }

    public function edit($id)
    {
        $banner = Banner::findOrFail($id);
        return view('admin.pages.banner.edit', compact('banner'));
    }

    public function update(Request $request, $id)
    {
        // Find the banner by ID
        $banner = Banner::find($id);
         // If the banner is not found, return with an error message
        if (!$banner) {
            return redirect()->back()->with('error', 'Banner not found');
        }

        // Update the banner image if a new one is provided
        if ($request->hasFile('banner')) {
            $image = $request->file('banner');
            $imageName = time() . '.' . $image->getClientOriginalExtension();
            $image->move(public_path('uploads/banners'), $imageName);

            // Delete the old banner image if it exists
            if ($banner->image) {
                File::delete(public_path('uploads/banners/' . $banner->image));
            }

        }else{
            $imageName = $request->input('oldbanner');
        }

        // Update the banner information in the database
        $banner->image = $imageName; // Adjust this field based on your database structure
        $banner->save();
        return redirect()->route('admin.banners')->with('success', 'Banner updated successfully.');
    }

    public function delete($id)
    {
        // Find the banner by ID
        $banner = Banner::find($id);

        // If the banner is not found, return with an error message
        if (!$banner) {
            return redirect()->back()->with('error', 'Banner not found');
        }

        // Delete the banner image if it exists
        if ($banner->image) {
            File::delete(public_path('uploads/banners/' . $banner->image));
        }

        // Delete the banner from the database
        $banner->delete();
        return redirect()->route('admin.banners')->with('success', 'Banner deleted successfully.');
    }

    public function changeStatus($bannerId)
    {
        $banner = Banner::find($bannerId);
        if (!$banner) {
            return response()->json(['error' => 'Banner not found'], 404);
        }
        $banner->status = $banner->status == '1' ? '0' : '1';
        $banner->save();
        return response()->json(['status' => $banner->status]);
    }


}
