<?php

namespace App\Http\Controllers\Admin\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Hash;


class AuthController extends Controller
{
    public function login()
    {
        return view('admin.auth.login');
    }

    public function postLogin(Request $request)
    {
         // Validate the form data
         $request->validate([
            'email' => 'required|email',
            'password' => 'required',
        ]);
        $credentials = $request->only('email', 'password');

        if (Auth::guard('admin')->attempt($credentials)) {
             $adminUser = Auth::guard('admin')->user();
             // Check if the user is authenticated
            if ($adminUser) {
                return redirect()->route('admin.dashboard');
            }else{
                Session::flash('error-message','Invalid Email or Password');
                return redirect()->back();
            }

        }else{
            Session::flash('error-message','Invalid Email or Password');
            return redirect()->back();
        }

    }


    public function logout()
    {
        Auth::guard('admin')->logout();
        return redirect()->route('adminlogin');
    }


}
